export const inView = (element) => {
  const target = element.firstElementChild;
  if (!target) return;

  const observer = new IntersectionObserver(
    (entries) => {
      entries.forEach((entry) => {
        if (entry.isIntersecting) {
          target.style.opacity = '1';
          target.style.transform = 'translateY(0)';
          observer.unobserve(element);
        }
      });
    },
    {
      threshold: 0.1
    }
  );

  observer.observe(element);

  // Set initial styles on the component
  target.style.opacity = '0';
  target.style.transform = 'translateY(50px)';
  target.style.transition = 'all 0.6s ease-out';

  return {
    destroy() {
      observer.unobserve(element);
    }
  };
};
