import {  locales } from '$lib/translations';

/** @type {import('@sveltejs/kit').Handle} */
export const handle = async ({ event, resolve }) => {
	const { url, request } = event;
	const { pathname } = url;

	// Get defined locales
	const supportedLocales = locales.get().map((l) => l.toLowerCase());

	// Try to get locale from `pathname`.
	let locale = supportedLocales.find((l) => l === `${pathname.match(/[^/]+?(?=\/|$)/)}`.toLowerCase());

	// If route locale is not supported
	if (!locale) {
		// Get user preferred locale
		locale = `${`${request.headers.get('accept-language')}`.match(/[a-zA-Z]+?(?=-|_|,|;)/)}`.toLowerCase();

		// Set default locale if user preferred locale does not match
		if (!supportedLocales.includes(locale)) locale = 'en-us';

		// 301 redirect
		return new Response(undefined, { headers: { 'location': `/${locale}${pathname}` }, status: 301 });
	}

	// Add html `lang` attribute
	return resolve({ ...event, locals: { lang: locale } }, {
		transformPageChunk: ({ html }) => html.replace(/<html.*>/, `<html lang="${locale}">`),
	});
};



/** @type {import('@sveltejs/kit').HandleServerError} */
