import i18n from 'sveltekit-i18n';

/** @type {import('sveltekit-i18n').Config} */
const config = {
  loaders: [
    {
      locale: 'en-US',
      key: 'common',
      loader: async () => (await import('./locales/en-US.json')).default
    },

    {
      locale: 'ps-AF',
      key: 'common',
      loader: async () => (await import('./locales/ps-AF.json')).default
    },

    {
      locale: 'fa-AF',
      key: 'common',
      loader: async () => (await import('./locales/fa-AF.json')).default
    }
  ]
};

// export const defaultLocale = 'en-us';

export const { t, locale, locales, loading, loadTranslations } = new i18n(
  config
);
